/*
 * Decompiled with CFR 0.152.
 */
package jdave.tools;

import jdave.Specification;
import jdave.runner.Behavior;
import jdave.runner.Context;
import jdave.runner.ISpecVisitor;
import jdave.runner.SpecRunner;
import jdave.tools.IDoxFormat;
import jdave.tools.IDoxStore;

public class Specdox {
    private final IDoxStore fileStore;

    public Specdox(IDoxStore fileStore) {
        this.fileStore = fileStore;
    }

    public void generate(Class<? extends Specification<?>> specType, final IDoxFormat format) {
        String specName = specType.getSimpleName();
        format.newSpec(specName, specType.getName());
        new SpecRunner().visit(specType, new ISpecVisitor(){

            @Override
            public void afterContext(Context context) {
                format.endContext(context.getName());
            }

            @Override
            public void onContext(Context context) {
                format.newContext(context.getName());
            }

            @Override
            public void onBehavior(Behavior behavior) {
                format.newBehavior(behavior.getName());
            }
        });
        format.endSpec(specName);
        this.fileStore.store(specType.getSimpleName(), format.suffix(), format.toString());
    }
}

