/*
 * Decompiled with CFR 0.152.
 */
package jdave.tools;

import jdave.Specification;
import jdave.tools.FileStore;
import jdave.tools.Formats;
import jdave.tools.IDoxFormat;
import jdave.tools.Specdox;

public class SpecdoxRunner {
    public static final String FORMAT = "jdave.tools.specdox.format";
    public static final String DIRNAME = "jdave.tools.specdox.dir";
    private final Formats formats;

    public SpecdoxRunner() {
        this(new Formats());
    }

    public SpecdoxRunner(Formats formats) {
        this.formats = formats;
    }

    public void generate(Class<? extends Specification<?>> specType) {
        if (System.getProperty(FORMAT) != null) {
            for (String s : System.getProperty(FORMAT).split("\\s+")) {
                IDoxFormat format = this.formats.formatFor(s);
                Specdox specdox = new Specdox(new FileStore(this.dirname()));
                specdox.generate(specType, format);
            }
        }
    }

    private String dirname() {
        return System.getProperty(DIRNAME, "target/jdave");
    }
}

