/*
 * Decompiled with CFR 0.152.
 */
package jdave.tools;

import jdave.tools.IDoxFormat;
import jdave.tools.Sentence;

public class XmlFormat
implements IDoxFormat {
    private StringBuilder dox = new StringBuilder();

    @Override
    public void newSpec(String specName, String fqn) {
        this.dox.append("<specification name=\"").append(specName).append("\" fqn=\"").append(fqn).append("\">\n");
        this.dox.append("  <contexts>\n");
    }

    @Override
    public void endSpec(String specName) {
        this.dox.append("  </contexts>\n");
        this.dox.append("</specification>\n");
    }

    @Override
    public void newContext(String contextName) {
        this.dox.append("    <context name=\"").append(Sentence.fromCamelCase(contextName)).append("\">\n");
        this.dox.append("      <behaviors>\n");
    }

    @Override
    public void endContext(String name) {
        this.dox.append("      </behaviors>\n");
        this.dox.append("    </context>\n");
    }

    @Override
    public void newBehavior(String behaviorName) {
        this.dox.append("        <behavior name=\"").append(Sentence.fromCamelCase(behaviorName)).append("\" />\n");
    }

    @Override
    public String suffix() {
        return "xml";
    }

    @Override
    public String toString() {
        return this.dox.toString();
    }
}

