/*
 * Decompiled with CFR 0.152.
 */
package jdave.examples.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdave.examples.wicket.IDictionaryService;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.markup.repeater.util.ModelIteratorAdapter;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public abstract class DictionaryPanel
extends Panel {
    private List<String> hits = new ArrayList<String>();
    private String query;

    public DictionaryPanel(String id) {
        super(id);
        this.add((Component)new FeedbackPanel("feedback"));
        this.add((Component)new Form("form"){
            {
                this.add((Component)new TextField("query", (IModel)new PropertyModel((Object)DictionaryPanel.this, "query")));
            }

            protected void onSubmit() {
                DictionaryPanel.this.hits = DictionaryPanel.this.getService().lookup(DictionaryPanel.this.query);
                if (DictionaryPanel.this.hits.isEmpty()) {
                    DictionaryPanel.this.info("No hits.");
                }
            }
        });
        this.add((Component)new RefreshingView("words"){

            protected Iterator<?> getItemModels() {
                return new ModelIteratorAdapter(DictionaryPanel.this.hits.iterator()){

                    protected IModel model(Object object) {
                        return new Model((Serializable)((Object)((String)object)));
                    }
                };
            }

            protected void populateItem(Item item) {
                item.add((Component)new Label("word", item.getModelObjectAsString()));
            }
        });
    }

    protected abstract IDictionaryService getService();
}

