/*
 * Decompiled with CFR 0.152.
 */
package jdave.junit4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jdave.Specification;
import jdave.junit4.CodeSource;
import jdave.junit4.DescriptionFactory;
import jdave.junit4.JDaveRunner;
import jdave.junit4.SpecDirs;
import jdave.runner.AnnotatedSpecScanner;
import jdave.runner.Groups;
import jdave.runner.IAnnotatedSpecHandler;
import jdave.runner.Resolution;
import net.sf.cglib.asm.Type;
import net.sf.cglib.asm.attrs.Annotation;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDaveGroupRunner
extends Runner {
    private final Class<?> suite;
    private final List<Class<? extends Specification<?>>> specs = new ArrayList();

    public JDaveGroupRunner(Class<?> suite) {
        this.suite = suite;
    }

    public Description getDescription() {
        this.specs.clear();
        Description desc = Description.createSuiteDescription(this.suite);
        Resolution resolution = new Resolution(this.suite.getAnnotation(Groups.class));
        for (String dir : this.findRootDirs()) {
            this.scanDir(dir, desc, resolution);
        }
        return desc;
    }

    private void scanDir(String dir, final Description desc, final Resolution resolution) {
        this.newAnnotatedSpecScanner(dir).forEach(new IAnnotatedSpecHandler(){

            public void handle(String classname, String ... groups) {
                if (resolution.includes(Arrays.asList(groups))) {
                    Class spec = JDaveGroupRunner.this.loadClass(classname);
                    JDaveGroupRunner.this.specs.add(spec);
                    desc.addChild(DescriptionFactory.create(spec));
                }
            }
        });
    }

    private List<String> findRootDirs() {
        ArrayList<String> rootDirs = new ArrayList<String>();
        if (this.suite.isAnnotationPresent(SpecDirs.class)) {
            rootDirs.addAll(Arrays.asList(this.suite.getAnnotation(SpecDirs.class).value()));
        } else {
            CodeSource codeSource = CodeSource.of(this.suite);
            rootDirs.add(codeSource.getDirectory());
        }
        return rootDirs;
    }

    protected AnnotatedSpecScanner newAnnotatedSpecScanner(String suiteLocation) {
        return new AnnotatedSpecScanner(suiteLocation){

            public boolean isInDefaultGroup(String classname, Collection<Annotation> annotations) {
                for (Annotation annotation : annotations) {
                    if (!annotation.type.equals("Lorg/junit/runner/RunWith;")) continue;
                    Type runner = (Type)((Object[])annotation.elementValues.get(0))[1];
                    return runner.getClassName().equals(JDaveRunner.class.getName());
                }
                return false;
            }
        };
    }

    private Class<? extends Specification<?>> loadClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        try {
            this.onBeforeRun();
            this.runSpecs(notifier);
        }
        finally {
            this.onAfterRun();
        }
    }

    private void runSpecs(RunNotifier notifier) {
        for (Class<? extends Specification<?>> clazz : this.specs) {
            new JDaveRunner(clazz).run(notifier);
        }
    }

    protected void onBeforeRun() {
    }

    protected void onAfterRun() {
    }
}

