/*
 * Decompiled with CFR 0.152.
 */
package jdave.junit4;

import java.lang.annotation.Annotation;
import jdave.Specification;
import jdave.runner.Behavior;
import jdave.runner.Context;
import jdave.runner.ISpecVisitor;
import jdave.runner.SpecRunner;
import org.junit.runner.Description;

public class DescriptionFactory
implements ISpecVisitor {
    private final Description description;
    private Description contextDescription;

    public DescriptionFactory(Description description) {
        this.description = description;
    }

    public static Description create(Class<? extends Specification<?>> spec) {
        Description description = Description.createSuiteDescription((String)spec.getName(), (Annotation[])new Annotation[0]);
        DescriptionFactory factory = new DescriptionFactory(description);
        new SpecRunner().visit(spec, (ISpecVisitor)factory);
        return description;
    }

    public void onContext(Context context) {
        this.contextDescription = Description.createSuiteDescription((String)context.getName(), (Annotation[])new Annotation[0]);
        this.description.addChild(this.contextDescription);
    }

    public void onBehavior(Behavior behavior) {
        this.contextDescription.addChild(DescriptionFactory.newDescription(behavior));
    }

    static Description newDescription(Behavior behavior) {
        return Description.createTestDescription((Class)behavior.getContextType(), (String)behavior.getName());
    }

    public void afterContext(Context context) {
    }
}

