/*
 * Decompiled with CFR 0.152.
 */
package jdave.junit4;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdave.Specification;
import jdave.junit4.CodeSource;
import jdave.junit4.DescriptionFactory;
import jdave.junit4.JDaveRunner;
import jdave.junit4.SpecDirs;
import jdave.runner.AnnotatedSpecScanner;
import jdave.runner.Groups;
import jdave.runner.IAnnotatedSpecHandler;
import jdave.runner.Resolution;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

public class JDaveGroupRunner
extends Runner {
    private final Class<?> suite;
    private final List<Class<? extends Specification<?>>> specs = new ArrayList();
    private final Description description;

    public JDaveGroupRunner(Class<?> suite) {
        this.suite = suite;
        this.description = Description.createSuiteDescription(suite);
        this.collectSpecsAndDescriptionBy(suite);
    }

    private void collectSpecsAndDescriptionBy(Class<?> suite) {
        Resolution resolution = new Resolution(suite.getAnnotation(Groups.class));
        for (String dir : this.findRootDirs()) {
            this.scanDir(dir, resolution);
        }
    }

    private void scanDir(String dir, final Resolution resolution) {
        this.newAnnotatedSpecScanner(dir).forEach(new IAnnotatedSpecHandler(){

            public void handle(String classname, String ... groups) {
                if (resolution.includes(Arrays.asList(groups))) {
                    Class spec = JDaveGroupRunner.this.loadClass(classname);
                    JDaveGroupRunner.this.specs.add(spec);
                    JDaveGroupRunner.this.description.addChild(DescriptionFactory.create(spec));
                }
            }
        });
    }

    private List<String> findRootDirs() {
        ArrayList<String> rootDirs = new ArrayList<String>();
        if (this.suite.isAnnotationPresent(SpecDirs.class)) {
            rootDirs.addAll(Arrays.asList(this.suite.getAnnotation(SpecDirs.class).value()));
        } else {
            CodeSource codeSource = CodeSource.of(this.suite);
            rootDirs.add(codeSource.getDirectory());
        }
        return rootDirs;
    }

    protected AnnotatedSpecScanner newAnnotatedSpecScanner(String suiteLocation) {
        return new AnnotatedSpecScanner(suiteLocation){

            public boolean isInDefaultGroup(String classname, Annotation ... annotations) {
                for (Annotation annotation : annotations) {
                    if (!annotation.annotationType().equals(RunWith.class)) continue;
                    RunWith runWith = (RunWith)annotation;
                    return runWith.value().equals(JDaveRunner.class);
                }
                return false;
            }
        };
    }

    private Class<? extends Specification<?>> loadClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        try {
            this.onBeforeRun();
            this.runSpecs(notifier);
        }
        finally {
            this.onAfterRun();
        }
    }

    private void runSpecs(RunNotifier notifier) {
        for (Class<? extends Specification<?>> clazz : this.specs) {
            new JDaveRunner(clazz).run(notifier);
        }
    }

    protected void onBeforeRun() {
    }

    protected void onAfterRun() {
    }

    public Description getDescription() {
        return this.description;
    }
}

