/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.builders;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class AnnotatedBuilder
extends RunnerBuilder {
    private static final String CONSTRUCTOR_ERROR_FORMAT = "Custom runner class %1$s should have a public constructor with signature %1$s(Class testClass) or %1$s(Class testClass, RunnerBuilder builder)";
    private final RunnerBuilder suiteBuilder;

    public AnnotatedBuilder(RunnerBuilder suiteBuilder) {
        this.suiteBuilder = suiteBuilder;
    }

    public Runner runnerForClass(Class<?> testClass) throws Exception {
        RunWith annotation = this.getRunWithAnnotation(testClass);
        if (annotation != null) {
            return this.buildRunner(annotation.value(), testClass);
        }
        return null;
    }

    private RunWith getRunWithAnnotation(Class<?> testClass) {
        if (testClass.isAnnotationPresent(RunWith.class)) {
            return testClass.getAnnotation(RunWith.class);
        }
        if (this.testClassIsANonStaticInnerClass(testClass)) {
            return testClass.getDeclaringClass().getAnnotation(RunWith.class);
        }
        return null;
    }

    private boolean testClassIsANonStaticInnerClass(Class<?> testClass) {
        return testClass.isMemberClass() && !Modifier.isStatic(testClass.getModifiers());
    }

    private <T extends Runner> T buildRunner(Class<T> runnerClass, Class<?> testClass) throws Exception {
        return (T)((InternalBuilder)new InternalBuilder<T>(runnerClass, this.suiteBuilder)).build(testClass);
    }

    private static class InternalBuilder<T extends Runner> {
        private final RunnerBuilder suiteBuilder;
        private final Class<T> runnerClass;

        public InternalBuilder(Class<T> runnerClass, RunnerBuilder suiteBuilder) {
            this.runnerClass = runnerClass;
            this.suiteBuilder = suiteBuilder;
        }

        private T build(Class<?> testClass) throws Exception {
            if (this.hasValidConstructor()) {
                return this.instantiateRunner(testClass);
            }
            throw new InitializationError(String.format(AnnotatedBuilder.CONSTRUCTOR_ERROR_FORMAT, this.runnerClass.getSimpleName()));
        }

        private T instantiateRunner(Class<?> testClass) throws Exception {
            if (this.hasSimpleConstructor()) {
                return (T)((Runner)this.getSimpleConstructor().newInstance(testClass));
            }
            return (T)((Runner)this.getConstructorWithSuite(this.runnerClass).newInstance(testClass, this.suiteBuilder));
        }

        private boolean hasValidConstructor() {
            return this.hasSimpleConstructor() || this.hasConstructorWithSuite();
        }

        private boolean hasSimpleConstructor() {
            return this.getSimpleConstructor() != null;
        }

        private boolean hasConstructorWithSuite() {
            return this.getConstructorWithSuite(this.runnerClass) != null;
        }

        private Constructor<T> getSimpleConstructor() {
            for (Constructor<T> constructor : this.getConstructors(this.runnerClass)) {
                List<Class<?>> parameters = Arrays.asList(constructor.getParameterTypes());
                if (!parameters.equals(Arrays.asList(Class.class))) continue;
                return constructor;
            }
            return null;
        }

        private Constructor<T> getConstructorWithSuite(Class<T> runnerClass) {
            for (Constructor<T> constructor : this.getConstructors(runnerClass)) {
                List<Class<?>> parameters = Arrays.asList(constructor.getParameterTypes());
                if (!parameters.equals(Arrays.asList(Class.class, RunnerBuilder.class))) continue;
                return constructor;
            }
            return null;
        }

        private List<Constructor<T>> getConstructors(Class<T> clazz) {
            return Arrays.asList(clazz.getConstructors());
        }
    }
}

