/*
 * Decompiled with CFR 0.152.
 */
package org.jdave.maven.report;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.jdave.maven.report.SpecdoxTransformer;

public class JDaveReportMojo
extends AbstractMavenReport {
    protected String outputDirectory;
    protected SiteRenderer siteRenderer;
    protected MavenProject project;
    protected File reportsDirectory;
    protected File xrefLocation;

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            this.getSink().rawText("<iframe src=\"jdave.html\" width=\"100%\" height=\"800\" />");
            this.getSink().flush();
            this.getSink().close();
            new SpecdoxTransformer().transform("jdave.html", this.reportsDirectory.toURI().toString(), this.outputDirectory, this.xrefLocation);
        }
        catch (TransformerException e) {
            throw new MavenReportException("could not create a file", (Exception)e);
        }
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.jdave.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.jdave.description");
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getOutputName() {
        return "jdave-report";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jdave-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public boolean canGenerateReport() {
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        return "java".equals(artifactHandler.getLanguage());
    }
}

