/*
 * Decompiled with CFR 0.152.
 */
package jdave.unfinalizer.internal;

import com.sun.tools.attach.VirtualMachineDescriptor;
import java.util.List;
import java.util.Properties;
import jdave.unfinalizer.internal.JVMHelper;

public class Filter {
    public VirtualMachineDescriptor getCurrentJvm(JVMHelper jvmHelper) {
        List<VirtualMachineDescriptor> jvms = jvmHelper.virtualMachines();
        for (VirtualMachineDescriptor virtualMachineDescriptor : jvms) {
            if (!jvmHelper.getCurrentRuntimeName().startsWith(virtualMachineDescriptor.id())) continue;
            return virtualMachineDescriptor;
        }
        throw new RuntimeException("could not find current virtual machine.");
    }

    public String getUnfinalizerJarPath(Properties properties) {
        String[] classPathItems;
        String classPath = properties.getProperty("java.class.path");
        String pathSeparator = properties.getProperty("path.separator");
        for (String classPathItem : classPathItems = classPath.split(pathSeparator)) {
            if (!classPathItem.matches("(.*)jdave-unfinalizer(.*).jar")) continue;
            return classPathItem;
        }
        throw new RuntimeException("cannot find jdave unfinalizer in class path");
    }
}

