/*
 * Decompiled with CFR 0.152.
 */
package jdave.org.objectweb.asm;

import jdave.org.objectweb.asm.ByteVector;
import jdave.org.objectweb.asm.ClassReader;
import jdave.org.objectweb.asm.ClassWriter;
import jdave.org.objectweb.asm.Label;

public class Attribute {
    public final String type;
    byte[] value;
    Attribute next;

    protected Attribute(String type) {
        this.type = type;
    }

    public boolean isUnknown() {
        return true;
    }

    public boolean isCodeAttribute() {
        return false;
    }

    protected Label[] getLabels() {
        return null;
    }

    protected Attribute read(ClassReader cr, int off, int len) {
        Attribute attr = new Attribute(this.type);
        attr.value = new byte[len];
        System.arraycopy(cr.b, off, attr.value, 0, len);
        return attr;
    }

    protected ByteVector write() {
        ByteVector v = new ByteVector();
        v.data = this.value;
        v.length = this.value.length;
        return v;
    }

    final int getCount() {
        int count = 0;
        Attribute attr = this;
        while (attr != null) {
            ++count;
            attr = attr.next;
        }
        return count;
    }

    final int getSize(ClassWriter cw) {
        Attribute attr = this;
        int size = 0;
        while (attr != null) {
            cw.newUTF8(attr.type);
            size += attr.write().length + 6;
            attr = attr.next;
        }
        return size;
    }

    final void put(ClassWriter cw, ByteVector out) {
        Attribute attr = this;
        while (attr != null) {
            ByteVector b = attr.write();
            out.putShort(cw.newUTF8(attr.type)).putInt(b.length);
            out.putByteArray(b.data, 0, b.length);
            attr = attr.next;
        }
    }
}

