/*
 * Decompiled with CFR 0.152.
 */
package jdave.contract;

import java.util.Comparator;
import jdave.ExpectationFailedException;
import jdave.IContract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EqualsComparableContract<T>
implements IContract {
    private Comparator<T> comparator;

    public EqualsComparableContract() {
    }

    public EqualsComparableContract(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    @Override
    public void isSatisfied(Object obj) throws ExpectationFailedException {
        Object object = obj;
        if (this.comparator == null) {
            this.comparator = new ComparableComparator();
            try {
                ((Comparable)obj).compareTo(null);
                throw new ExpectationFailedException(object.getClass().getName() + ".compareTo(null) should throw NullpointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.comparator.compare(object, object) != 0) {
            throw new ExpectationFailedException("comparison should be 0, if objects are equal");
        }
        if (this.comparator.compare(object, this.preceding()) <= 0) {
            throw new ExpectationFailedException(object + " should be after " + this.preceding());
        }
        if (this.comparator.compare(object, this.subsequent()) >= 0) {
            throw new ExpectationFailedException(object + " should be before " + this.subsequent());
        }
        if (this.equivalentByComparisonButNotByEqual() != null && this.comparator.compare(object, this.equivalentByComparisonButNotByEqual()) == 0) {
            throw new ExpectationFailedException("comparison is not consistent with equals, " + object + ", " + this.subsequent());
        }
    }

    protected abstract T preceding();

    protected abstract T subsequent();

    protected abstract T equivalentByComparisonButNotByEqual();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComparableComparator<T extends Comparable<Object>>
    implements Comparator<T> {
        private ComparableComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return o1.compareTo(o2);
        }
    }
}

