/*
 * Copyright 2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdave.examples;

import java.util.Collection;
import java.util.Iterator;

/**
 * @author Joni Freeman
 * @author Pekka Enberg
 */
public class Stack<T> implements Collection<T> {
    private static final int UNLIMITED = -1;
    private final int maxSize;
    private java.util.Stack<T> stack = new java.util.Stack<T>();
    
    public Stack() {
        this(UNLIMITED);
    }
    
    public Stack(int maxSize) {
        this.maxSize = maxSize;
    }

    public boolean empty() {
        return stack.isEmpty();
    }

    public boolean full() {
        return maxSize != UNLIMITED && stack.size() == maxSize;
    }

    public T peek() {
        return stack.peek();
    }

    public void push(T element) {
        if (full()) {
            throw new StackOverflowException();
        }
        stack.push(element);
    }

    public boolean add(T o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object o) {
        return stack.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return stack.containsAll(c);
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public Iterator<T> iterator() {
        return stack.iterator();
    }

    public boolean remove(Object o) {
        return stack.remove(o);
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return stack.size();
    }

    public Object[] toArray() {
        return stack.toArray();
    }

    public <V> V[] toArray(V[] a) {
        return stack.toArray(a);
    }
    
    @Override
    public String toString() {
        return stack.toString();
    }
}
