/*
 * Decompiled with CFR 0.152.
 */
package jdave.junit4;

import jdave.junit4.DescriptionFactory;
import jdave.junit4.ResultsAdapter;
import jdave.runner.Behavior;
import jdave.runner.Context;
import jdave.runner.IBehaviorResults;
import jdave.runner.ISpecVisitor;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunNotifier;

public class JDaveCallback
implements ISpecVisitor {
    private final RunNotifier notifier;
    private Filter filter;

    public JDaveCallback(RunNotifier notifier) {
        this.notifier = notifier;
    }

    public JDaveCallback(RunNotifier notifier, Filter filter) {
        this.notifier = notifier;
        this.filter = filter;
    }

    public void onContext(Context context) {
    }

    public void afterContext(Context context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBehavior(Behavior behavior) {
        Description desc = DescriptionFactory.newDescription(behavior);
        boolean shouldRun = this.shouldRun(desc);
        if (shouldRun) {
            this.notifier.fireTestStarted(desc);
            try {
                ResultsAdapter resultsAdapter = new ResultsAdapter(this.notifier, desc);
                behavior.run((IBehaviorResults)resultsAdapter);
            }
            finally {
                this.notifier.fireTestFinished(desc);
            }
        }
    }

    private boolean shouldRun(Description desc) {
        if (this.filter != null) {
            boolean shouldRun = this.filter.shouldRun(desc);
            return shouldRun;
        }
        return true;
    }
}

