/*
 * Decompiled with CFR 0.152.
 */
package jdave.junit4;

import java.lang.reflect.Modifier;
import jdave.IStringComparisonFailure;
import jdave.Specification;
import jdave.junit4.DescriptionFactory;
import jdave.junit4.JDaveCallback;
import jdave.runner.ISpecVisitor;
import jdave.runner.SpecRunner;
import jdave.tools.SpecdoxRunner;
import junit.framework.ComparisonFailure;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDaveRunner
extends Runner
implements Filterable {
    private final Class<? extends Specification<?>> spec;
    private final Description description;
    private Filter filter;

    public JDaveRunner(Class<?> testClass) {
        if (Specification.class.isAssignableFrom(testClass)) {
            this.spec = testClass;
        } else if (this.isAContext(testClass)) {
            this.spec = testClass.getDeclaringClass();
        } else {
            throw new IllegalArgumentException("Testclass is not a Specification or a Context: " + testClass);
        }
        Specification.setStringComparisonFailure((IStringComparisonFailure)new IStringComparisonFailure(){

            public void fail(String message, String expected, String actual) {
                throw new ComparisonFailure(message, expected, actual);
            }
        });
        this.description = DescriptionFactory.create(this.spec);
    }

    private boolean isAContext(Class<?> contextClass) {
        boolean isMemberClass = contextClass.isMemberClass();
        if (!isMemberClass) {
            return false;
        }
        boolean isStatic = Modifier.isStatic(contextClass.getModifiers());
        if (isStatic) {
            return false;
        }
        Class<?> declaringClass = contextClass.getDeclaringClass();
        boolean declaringClassIsASpecification = Specification.class.isAssignableFrom(declaringClass);
        return declaringClassIsASpecification;
    }

    public Description getDescription() {
        return this.description;
    }

    public void run(RunNotifier notifier) {
        new SpecRunner().run(this.spec, (ISpecVisitor)new JDaveCallback(notifier, this.filter));
        new SpecdoxRunner().generate(this.spec);
    }

    public void filter(Filter filter) {
        this.filter = filter;
    }
}

