/*
 * Decompiled with CFR 0.152.
 */
package fast.bats.europe;

import fast.Message;
import fast.bats.europe.Elements;
import fast.templates.MessageTemplate;

public class FastPitchMessage
extends Message {
    private static final int LONG_BASE_36_LEN = 6;

    public FastPitchMessage(MessageTemplate template) {
        super(template);
    }

    public String getSymbol() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.symbol1());
        buf.append(this.symbol2());
        return buf.toString();
    }

    private String symbol1() {
        return this.get(Elements.SYMBOL_1);
    }

    private String symbol2() {
        return this.get(Elements.SYMBOL_2);
    }

    public String getSide() {
        return this.get(Elements.SIDE);
    }

    public String getOrderId() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.orderId1());
        buf.append(this.orderId2());
        buf.append(this.orderId3());
        buf.append(this.orderId4());
        return buf.toString();
    }

    private String orderId1() {
        return this.get(Elements.ORDER_ID_1);
    }

    private String orderId2() {
        return this.get(Elements.ORDER_ID_2);
    }

    private String orderId3() {
        return this.get(Elements.ORDER_ID_3);
    }

    private String orderId4() {
        long orderId4 = this.get(Elements.ORDER_ID_4);
        return FastPitchMessage.encodeFixedWidthBase36String(orderId4);
    }

    public String getPrice() {
        String price1 = Long.toString(this.get(Elements.PRICE_1));
        String price2 = this.get(Elements.PRICE_2);
        return FastPitchMessage.removeLeadingAndTrailingZeroes(price1 + "." + price2);
    }

    public String getLongPrice() {
        StringBuffer b = new StringBuffer("");
        b.append(this.longPrice1());
        b.append(this.longPrice2());
        b.append(".");
        b.append(this.longPrice3());
        b.append(this.longPrice4());
        return FastPitchMessage.removeLeadingAndTrailingZeroes(b.toString());
    }

    private String longPrice1() {
        return String.format("%06d", Integer.valueOf(this.get(Elements.LONG_PRICE_1)));
    }

    private String longPrice2() {
        return String.format("%06d", this.get(Elements.LONG_PRICE_2));
    }

    private String longPrice3() {
        return String.format("%04d", this.get(Elements.LONG_PRICE_3));
    }

    private String longPrice4() {
        return this.get(Elements.LONG_PRICE_4);
    }

    public long getShares() {
        return this.get(Elements.SHARES);
    }

    private static String encodeFixedWidthBase36String(long value) {
        byte[] bytes = new byte[6];
        for (int i = bytes.length - 1; i >= 0; --i) {
            int curLeastSignificantBase36int = (int)(value % 36L);
            bytes[i] = (byte)FastPitchMessage.printableChar(curLeastSignificantBase36int);
            value /= 36L;
        }
        return new String(bytes);
    }

    private static int printableChar(int base36int) {
        if (base36int > 9) {
            int characterIndex = base36int - 10;
            return 65 + characterIndex;
        }
        int numberIndex = base36int;
        return 48 + numberIndex;
    }

    private static String removeLeadingAndTrailingZeroes(String s) {
        return s.replaceFirst("^0*", "").replaceFirst("0+\\z", "");
    }
}

