/*
 * Decompiled with CFR 0.152.
 */
package fast.bats.europe.session;

import fast.Encoder;
import fast.Message;
import fast.soup.Elements;
import fast.soup.templates.LoginRequest;
import fast.soup.templates.LogoutRequest;
import fast.soup.templates.ServerHeartbeat;
import java.nio.ByteBuffer;
import silvertip.Connection;

public class Session {
    private static final String SESSION = "0006";
    private static final String SEQUENCE_NUMBER = "";
    private static final long HEARTBEAT_INTERVAL_MSEC = 1000L;
    private long lastHeartbeatTimeMsec = 0L;
    private final Encoder encoder;

    public Session(Encoder encoder) {
        this.encoder = encoder;
    }

    public void login(Connection<?> connection, String username, String password) {
        Message message = new Message(LoginRequest.TEMPLATE);
        message.set(Elements.USERNAME, username);
        message.set(Elements.PASSWORD, password);
        message.set(Elements.SESSION, SESSION);
        message.set(Elements.SEQUENCE_NUMBER, SEQUENCE_NUMBER);
        this.send(connection, message);
    }

    public void logout(Connection<?> connection) {
        this.send(connection, new Message(LogoutRequest.TEMPLATE));
    }

    public void heartbeat(Connection<?> connection) {
        this.send(connection, new Message(ServerHeartbeat.TEMPLATE));
    }

    public void receive(Connection<?> connection, Message message) {
        long currentTimeMsec = System.currentTimeMillis();
        if (currentTimeMsec - this.lastHeartbeatTimeMsec >= 1000L) {
            this.heartbeat(connection);
            this.lastHeartbeatTimeMsec = currentTimeMsec;
        }
    }

    private void send(Connection<?> connection, Message message) {
        ByteBuffer buffer = this.encoder.encode(message);
        connection.send(new silvertip.Message(this.bytes(buffer)));
    }

    private byte[] bytes(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.position()];
        for (int i = 0; i < buffer.position(); ++i) {
            bytes[i] = buffer.get(i);
        }
        buffer.position(0);
        return bytes;
    }
}

