/*
 * Decompiled with CFR 0.152.
 */
package fast.elements;

import fast.Dictionary;
import fast.elements.Elem;
import fast.elements.PresenceMap;
import fast.operators.FieldOperator;
import fast.types.Type;
import java.nio.ByteBuffer;
import silvertip.PartialMessageException;

public abstract class AbstractElem<T>
implements Elem<T> {
    private final Type<T> type;
    private final FieldOperator<T> operator;
    private final int maxLength;

    protected AbstractElem(Type<T> type, FieldOperator<T> operator, int maxLength) {
        this.type = type;
        this.operator = operator;
        this.maxLength = maxLength;
    }

    protected AbstractElem(Type<T> type, FieldOperator<T> operator) {
        this(type, operator, Integer.MAX_VALUE);
    }

    @Override
    public T decode(final ByteBuffer buffer, final PresenceMap pmap, final Dictionary dictionary) throws PartialMessageException {
        return this.operator.apply(new FieldOperator.Visitor<T>(){

            @Override
            public boolean isPresent() {
                return pmap.isPresent(AbstractElem.this);
            }

            @Override
            public T decode() throws PartialMessageException {
                return AbstractElem.this.type.decode(buffer, AbstractElem.this.maxLength);
            }

            @Override
            public T getPreviousValue() {
                return dictionary.get(AbstractElem.this);
            }

            @Override
            public void setAsPreviousValue(T value) {
                dictionary.put(AbstractElem.this, value);
            }
        });
    }
}

