/*
 * Decompiled with CFR 0.152.
 */
package fast.elements;

import fast.elements.AbstractElem;
import fast.operators.FieldOperator;
import fast.types.Type;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class Field<T>
extends AbstractElem<T>
implements Comparable<Field<?>> {
    private final String name;
    private final Type<T> type;
    private int maxLength = Integer.MAX_VALUE;

    protected Field(String name, Type<T> type, FieldOperator<T> operator, int maxLength) {
        super(type, operator, maxLength);
        this.name = name;
        this.type = type;
        this.maxLength = maxLength;
    }

    protected Field(String name, Type<T> type, FieldOperator<T> operator) {
        this(name, type, operator, Integer.MAX_VALUE);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Field<?> field) {
        return this.getName().compareTo(field.getName());
    }

    public byte[] getBytes(T value) {
        byte[] valueAsBytes = this.type.getBytes(value);
        if (this.maxLength == Integer.MAX_VALUE) {
            return valueAsBytes;
        }
        return this.padded(valueAsBytes);
    }

    private byte[] padded(byte[] valueAsBytes) {
        ByteBuffer buffer = ByteBuffer.allocate(this.maxLength);
        Arrays.fill(buffer.array(), (byte)32);
        buffer.put(valueAsBytes);
        return buffer.array();
    }
}

