/*
 * Decompiled with CFR 0.152.
 */
package fast.templates;

import fast.Dictionary;
import fast.Encoder;
import fast.FieldContainer;
import fast.elements.Field;
import fast.elements.PresenceMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import silvertip.PartialMessageException;

public abstract class Template<T extends FieldContainer> {
    private final List<Field<?>> fields = new ArrayList();

    protected void add(Field<?> field) {
        this.fields.add(field);
    }

    protected void add(Template<?> template) {
        for (Field<?> field : template.fields) {
            this.add(field);
        }
    }

    public T decode(ByteBuffer buffer, PresenceMap pmap, Dictionary dictionary) throws PartialMessageException {
        T result = this.newFieldContainer();
        for (Field<?> field : this.fields) {
            ((FieldContainer)result).set(field, field.decode(buffer, pmap, dictionary));
        }
        return result;
    }

    protected abstract T newFieldContainer();

    public void encode(ByteBuffer buffer, FieldContainer container, Encoder encoder) {
        for (Field<?> field : this.fields) {
            encoder.encode(container, field, buffer);
        }
    }
}

