/*
 * Decompiled with CFR 0.152.
 */
package fast.types;

import fast.types.Type;
import java.nio.ByteBuffer;

public class AsciiString
extends Type<String> {
    public static final AsciiString TYPE = new AsciiString();

    @Override
    public ByteBuffer encode(String string) {
        byte[] bytes = string.getBytes();
        if (this.containsStopBit(bytes)) {
            throw new IllegalArgumentException("Argument contains stop bit (FAST Specification: ERR D11)");
        }
        bytes[bytes.length - 1] = this.addStopBit(bytes[bytes.length - 1]);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public byte[] getBytes(String value) {
        return value.getBytes();
    }

    @Override
    protected Type.Decoder<String> createDecoder() {
        return new Type.Decoder<String>(){
            StringBuffer output = new StringBuffer();

            @Override
            public String getResult() {
                return this.output.toString();
            }

            @Override
            public void process(byte b) {
                this.output.append((char)b);
            }
        };
    }
}

