/*
 * Decompiled with CFR 0.152.
 */
package fast.types;

import java.nio.ByteBuffer;
import silvertip.PartialMessageException;

public abstract class Type<T> {
    static final byte ALL_BUT_STOP_BIT_MASK = 127;
    static final byte STOP_BIT_MASK = -128;

    protected abstract Decoder<T> createDecoder();

    public abstract ByteBuffer encode(T var1);

    public final T decode(ByteBuffer buffer) throws PartialMessageException {
        return this.decode(buffer, Integer.MAX_VALUE);
    }

    public abstract byte[] getBytes(T var1);

    public final T decode(ByteBuffer buffer, int maxLength) throws PartialMessageException {
        Decoder<T> decoder = this.createDecoder();
        int startPosition = buffer.position();
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            decoder.process(this.decodeByte(b));
            if (!this.hasStopBit(b) && buffer.position() - startPosition != maxLength) continue;
            return decoder.getResult();
        }
        throw new PartialMessageException();
    }

    protected final boolean containsStopBit(byte[] bytes) {
        for (byte b : bytes) {
            if (!this.hasStopBit(b)) continue;
            return true;
        }
        return false;
    }

    protected final byte decodeByte(byte b) {
        return (byte)(b & 0x7F);
    }

    protected final boolean hasStopBit(byte b) {
        return (b & 0xFFFFFF80) != 0;
    }

    protected final byte addStopBit(byte b) {
        return (byte)(b | 0xFFFFFF80);
    }

    public static interface Decoder<T> {
        public void process(byte var1);

        public T getResult();
    }
}

