/*
 * Decompiled with CFR 0.152.
 */
package fast.types;

import fast.types.Type;
import java.nio.ByteBuffer;

public class UnsignedInt32
extends Type<Long> {
    public static final UnsignedInt32 TYPE = new UnsignedInt32();
    private static final int MAX_U32_BYTES_IN_FAST = 5;

    @Override
    public ByteBuffer encode(Long value) {
        byte[] bytes = new byte[5];
        int index = 5;
        do {
            bytes[--index] = (byte)(value & 0x7FL);
        } while ((value = Long.valueOf(value >> 7)) != 0L);
        bytes[4] = this.addStopBit(bytes[4]);
        return ByteBuffer.wrap(bytes, index, 5 - index);
    }

    @Override
    protected Type.Decoder<Long> createDecoder() {
        return new Type.Decoder<Long>(){
            long value = 0L;

            @Override
            public Long getResult() {
                return this.value;
            }

            @Override
            public void process(byte b) {
                this.value = this.value << 7 | (long)b;
            }
        };
    }

    @Override
    public byte[] getBytes(Long value) {
        return value.toString().getBytes();
    }
}

