/*
 * Decompiled with CFR 0.152.
 */
package fast.bats.europe;

import fast.Dictionary;
import fast.Message;
import fast.bats.europe.PresenceMapFactory;
import fast.bats.europe.templates.SequenceData;
import fast.elements.PresenceMap;
import fast.soup.PacketType;
import fast.soup.templates.Debug;
import fast.soup.templates.EndOfSession;
import fast.soup.templates.LoginAccepted;
import fast.soup.templates.LoginRejected;
import fast.soup.templates.ServerHeartbeat;
import fast.templates.MessageTemplate;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import silvertip.GarbledMessageException;
import silvertip.MessageParser;
import silvertip.PartialMessageException;

public class FastPitchMessageParser
implements MessageParser<Message> {
    private final Dictionary dictionary = new Dictionary();
    private Map<String, MessageTemplate> decoders = new HashMap<String, MessageTemplate>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("S", SequenceData.TEMPLATE);
            this.put("+", Debug.TEMPLATE);
            this.put("Z", EndOfSession.TEMPLATE);
            this.put("A", LoginAccepted.TEMPLATE);
            this.put("J", LoginRejected.TEMPLATE);
            this.put("H", ServerHeartbeat.TEMPLATE);
        }
    };

    public Message parse(ByteBuffer buffer) throws PartialMessageException, GarbledMessageException {
        return this.decode(buffer);
    }

    private Message decode(ByteBuffer buffer) throws PartialMessageException, GarbledMessageException {
        PresenceMap pmap = PresenceMapFactory.create(buffer);
        String identifier = (String)PacketType.ELEM.decode(buffer, pmap, this.dictionary);
        MessageTemplate template = this.decoders.get(identifier);
        if (template == null) {
            buffer.reset();
            byte[] messageData = new byte[buffer.limit() - buffer.position()];
            buffer.get(messageData);
            throw new GarbledMessageException("unknown template identifer: " + identifier, messageData);
        }
        return (Message)template.decode(buffer, pmap, this.dictionary);
    }
}

