/*
 * Decompiled with CFR 0.152.
 */
package fast.bats.europe.templates;

import fast.Dictionary;
import fast.Message;
import fast.Sequence;
import fast.bats.europe.Elements;
import fast.bats.europe.FastPitchMessage;
import fast.bats.europe.templates.AddOrder;
import fast.bats.europe.templates.AddOrderLongForm;
import fast.bats.europe.templates.OrderCancel;
import fast.bats.europe.templates.OrderCancelLongForm;
import fast.bats.europe.templates.OrderExecuted;
import fast.bats.europe.templates.OrderExecutedLongForm;
import fast.bats.europe.templates.Trade;
import fast.bats.europe.templates.TradeBreak;
import fast.bats.europe.templates.TradeLongForm;
import fast.elements.PresenceMap;
import fast.templates.MessageTemplate;
import fast.templates.SequenceTemplate;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import silvertip.PartialMessageException;

public class SequenceData
extends MessageTemplate {
    public static final MessageTemplate TEMPLATE = new SequenceData();
    private Map<String, SequenceTemplate> sequenceDataTemplates = new HashMap<String, SequenceTemplate>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("A", AddOrder.TEMPLATE);
            this.put("d", AddOrder.TEMPLATE);
            this.put("a", AddOrderLongForm.TEMPLATE);
            this.put("X", OrderCancel.TEMPLATE);
            this.put("x", OrderCancelLongForm.TEMPLATE);
            this.put("E", OrderExecuted.TEMPLATE);
            this.put("e", OrderExecutedLongForm.TEMPLATE);
            this.put("P", Trade.TEMPLATE);
            this.put("p", TradeLongForm.TEMPLATE);
            this.put("r", Trade.TEMPLATE);
            this.put("B", TradeBreak.TEMPLATE);
        }
    };

    private SequenceData() {
        super("S");
        this.add(Elements.TIME_SECONDS);
        this.add(Elements.TIME_MILLISECONDS);
        this.add(Elements.MESSAGE_TYPE);
    }

    @Override
    public FastPitchMessage decode(ByteBuffer buffer, PresenceMap pmap, Dictionary dictionary) throws PartialMessageException {
        FastPitchMessage message = (FastPitchMessage)super.decode(buffer, pmap, dictionary);
        message.addSequence(this.marketDataSequence(buffer, pmap, message, dictionary));
        return message;
    }

    @Override
    protected FastPitchMessage newFieldContainer() {
        return new FastPitchMessage(this);
    }

    private Sequence marketDataSequence(ByteBuffer buffer, PresenceMap pmap, Message message, Dictionary dictionary) throws PartialMessageException {
        SequenceTemplate template = this.sequenceDataTemplates.get(this.messageType(message));
        if (template == null) {
            throw new RuntimeException("unknown message type: \"" + this.messageType(message) + "\"");
        }
        return (Sequence)template.decode(buffer, pmap, dictionary);
    }

    private String messageType(Message message) {
        return message.get(Elements.MESSAGE_TYPE);
    }
}

