/*
 * Decompiled with CFR 0.152.
 */
package fast.elements;

import fast.elements.Elem;
import java.util.HashMap;
import java.util.Map;

public class PresenceMap {
    private final byte[] pMapData;
    private final Map<Elem<?>, Integer> slots = new HashMap();

    public PresenceMap(byte[] pMapData) {
        this.pMapData = pMapData;
    }

    public boolean isPresent(int slot) {
        int offset = slot / 7;
        if (offset >= this.pMapData.length) {
            return false;
        }
        return (this.pMapData[offset] & 64 >> slot % 7) != 0;
    }

    public void setPresent(int slot) {
        int offset = slot / 7;
        if (offset >= this.pMapData.length) {
            throw new RuntimeException("presenceMapData too short to set slot " + slot + " present");
        }
        int n = offset;
        this.pMapData[n] = (byte)(this.pMapData[n] | 64 >> slot % 7);
    }

    public void setPresent(Elem<?> elem) {
        this.setPresent(this.slots.get(elem));
    }

    public boolean isPresent(Elem<?> elem) {
        return this.isPresent(this.slots.get(elem));
    }

    public void bind(Elem<?> elem, int slot) {
        this.slots.put(elem, slot);
    }

    public int getBinding(Elem<?> elem) {
        return this.slots.get(elem);
    }

    public byte[] getBytes() {
        return this.pMapData;
    }
}

