/*
 * Decompiled with CFR 0.152.
 */
package silvertip.protocols;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import silvertip.FixMessage;
import silvertip.GarbledMessageException;
import silvertip.MessageParser;
import silvertip.PartialMessageException;

public class FixMessageParser
implements MessageParser<FixMessage> {
    public static final char DELIMITER = '\u0001';

    @Override
    public final FixMessage parse(ByteBuffer buffer) throws GarbledMessageException, PartialMessageException {
        try {
            FixMessageHeader header = this.header(buffer);
            String msgType = this.parseField(buffer, Tag.MSG_TYPE);
            int trailerLength = this.trailer(buffer, header);
            byte[] message = new byte[header.getHeaderLength() + header.getBodyLength() + trailerLength];
            buffer.reset();
            buffer.get(message);
            return new FixMessage(message, msgType);
        }
        catch (GarbledMessageException e) {
            int nextMessagePosition = this.nextMessagePosition(buffer);
            buffer.reset();
            byte[] data = new byte[nextMessagePosition - buffer.position()];
            buffer.get(data);
            e.setMessageData(data);
            throw e;
        }
        catch (BufferUnderflowException e) {
            throw new PartialMessageException();
        }
    }

    private FixMessageHeader header(ByteBuffer buffer) throws GarbledMessageException {
        int start = buffer.position();
        String beginString = this.parseField(buffer, Tag.BEGIN_STRING);
        if (!this.isBeginStringValid(beginString)) {
            throw new GarbledMessageException((Object)((Object)Tag.BEGIN_STRING) + " is invalid, expected format FIX.m.n: " + beginString);
        }
        int bodyLength = this.bodyLength(buffer);
        return new FixMessageHeader(buffer.position() - start, bodyLength, buffer.position());
    }

    private int bodyLength(ByteBuffer buffer) throws GarbledMessageException {
        String bodyLength = this.parseField(buffer, Tag.BODY_LENGTH);
        try {
            return Integer.parseInt(bodyLength);
        }
        catch (NumberFormatException e) {
            throw new GarbledMessageException((Object)((Object)Tag.BODY_LENGTH) + " has invalid format: " + bodyLength);
        }
    }

    private boolean isBeginStringValid(String beginString) {
        return beginString.startsWith("FIX.") && Character.isDigit(beginString.charAt(4)) && Character.isDigit(beginString.charAt(6));
    }

    private int trailer(ByteBuffer buffer, FixMessageHeader header) throws GarbledMessageException, PartialMessageException {
        int trailerStart = header.getBodyStart() + header.getBodyLength();
        if (trailerStart > buffer.limit()) {
            throw new PartialMessageException();
        }
        buffer.reset();
        int expectedCheckSum = this.checksum(buffer, header.getHeaderLength() + header.getBodyLength());
        buffer.position(trailerStart);
        try {
            int checksum = this.parseChecksum(buffer);
            if (expectedCheckSum != checksum) {
                throw new GarbledMessageException((Object)((Object)Tag.CHECKSUM) + " mismatch, expected=" + expectedCheckSum + ", actual=" + checksum);
            }
        }
        catch (GarbledMessageException e) {
            buffer.position(header.getBodyStart());
            throw e;
        }
        return buffer.position() - trailerStart;
    }

    private int parseChecksum(ByteBuffer buffer) throws GarbledMessageException {
        String checksum = this.parseField(buffer, Tag.CHECKSUM);
        if (checksum.length() != 3) {
            throw new GarbledMessageException((Object)((Object)Tag.CHECKSUM) + " has invalid length: " + checksum);
        }
        try {
            return Integer.parseInt(checksum);
        }
        catch (NumberFormatException e) {
            throw new GarbledMessageException((Object)((Object)Tag.CHECKSUM) + " has invalid format: " + checksum);
        }
    }

    private String parseField(ByteBuffer buffer, Tag tag) throws GarbledMessageException {
        this.match(buffer, tag);
        return this.value(buffer, tag);
    }

    private void match(ByteBuffer buffer, Tag tag) throws GarbledMessageException {
        String expected = tag.number() + "=";
        int start = buffer.position();
        for (int i = 0; i < expected.length(); ++i) {
            byte c = buffer.get();
            if (c == expected.charAt(i)) continue;
            if (tag != Tag.BEGIN_STRING) {
                buffer.position(start - 1);
            }
            throw new GarbledMessageException("Expected tag not found: " + (Object)((Object)tag));
        }
    }

    private String value(ByteBuffer buffer, Tag tag) throws GarbledMessageException {
        byte ch;
        StringBuilder result = new StringBuilder();
        while ((ch = buffer.get()) != 1) {
            result.append((char)ch);
        }
        if (result.length() == 0) {
            throw new GarbledMessageException((Object)((Object)tag) + " is empty");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextMessagePosition(ByteBuffer buffer) {
        int start = buffer.position();
        try {
            while (buffer.hasRemaining()) {
                if (!this.skipToBeginString(buffer)) continue;
                int n = buffer.position();
                return n;
            }
            int n = buffer.position();
            return n;
        }
        catch (BufferUnderflowException e) {
            int n = buffer.position();
            return n;
        }
        finally {
            buffer.position(start);
        }
    }

    private boolean skipToBeginString(ByteBuffer buffer) {
        String beginString = "\u00018=";
        for (int i = 0; i < beginString.length(); ++i) {
            if (buffer.get() == beginString.charAt(i)) continue;
            if (i > 0) {
                buffer.position(buffer.position() - 1);
            }
            return false;
        }
        buffer.position(buffer.position() - beginString.length() + 1);
        return true;
    }

    private int checksum(ByteBuffer b, int end) {
        int checksum = 0;
        for (int i = 0; i < end; ++i) {
            checksum += b.get();
        }
        return checksum % 256;
    }

    private static enum Tag {
        BEGIN_STRING(8, "BeginString"),
        BODY_LENGTH(9, "BodyLength"),
        MSG_TYPE(35, "MsgType"),
        CHECKSUM(10, "CheckSum");

        private int tagNumber;
        private String name;

        private Tag(int tagNumber, String name) {
            this.tagNumber = tagNumber;
            this.name = name;
        }

        public int number() {
            return this.tagNumber;
        }

        public String toString() {
            return String.format("%s(%d)", this.name, this.tagNumber);
        }
    }

    private static class FixMessageHeader {
        private final int headerLength;
        private final int bodyLength;
        private final int bodyStart;

        public FixMessageHeader(int headerLength, int bodyLength, int bodyStart) {
            this.headerLength = headerLength;
            this.bodyLength = bodyLength;
            this.bodyStart = bodyStart;
        }

        public int getHeaderLength() {
            return this.headerLength;
        }

        public int getBodyLength() {
            return this.bodyLength;
        }

        public int getBodyStart() {
            return this.bodyStart;
        }
    }
}

