/*
 * Decompiled with CFR 0.152.
 */
package silvertip;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import silvertip.EventSource;

public class Events {
    private List<EventSource> sources = new ArrayList<EventSource>();
    private Selector selector;
    private boolean stopped;
    private long idleMsec;

    public static Events open(long idleMsec) throws IOException {
        return new Events(Selector.open(), idleMsec);
    }

    public Events(Selector selector, long idleMsec) {
        this.selector = selector;
        this.idleMsec = idleMsec;
    }

    public void register(EventSource source) throws IOException {
        SelectionKey result = source.register(this.selector, 1);
        result.attach(source);
        this.sources.add(source);
    }

    public void dispatch() throws IOException {
        long timeout = this.idleMsec;
        while (!this.stopped) {
            long start = System.nanoTime();
            int numKeys = this.selector.select(timeout);
            long end = System.nanoTime();
            this.unregisterClosed();
            if (this.selector.keys().isEmpty()) break;
            if (numKeys == 0) {
                if ((timeout -= TimeUnit.NANOSECONDS.toMillis(end - start)) > 0L) continue;
                this.timeout();
            } else {
                this.dispatchMessages();
            }
            timeout = this.idleMsec;
        }
    }

    private void unregisterClosed() {
        Iterator<EventSource> it = this.sources.iterator();
        while (it.hasNext()) {
            EventSource source = it.next();
            if (!source.isClosed()) continue;
            source.unregister();
            it.remove();
        }
    }

    private void timeout() {
        for (EventSource source : this.sources) {
            source.timeout();
        }
    }

    private void dispatchMessages() throws IOException {
        ArrayList<EventSource> newSources = new ArrayList<EventSource>();
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            EventSource source = (EventSource)key.attachment();
            if (key.isAcceptable()) {
                newSources.add(source.accept(key));
            }
            if (key.isReadable()) {
                source.read(key);
            } else if (key.isWritable()) {
                source.write(key);
            }
            it.remove();
        }
        for (EventSource source : newSources) {
            this.register(source);
        }
    }

    public void stop() {
        this.stopped = true;
        this.selector.wakeup();
    }
}

