/*
 * Decompiled with CFR 0.152.
 */
package silvertip.samples.pingpong;

import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import silvertip.PartialMessageException;
import silvertip.samples.pingpong.PingPongMessageParser;

public class PingPongMessageParserTest {
    private static final int RECEIVE_BUFFER_SIZE = 16;
    private final ByteBuffer receiveBuffer = ByteBuffer.allocate(16);
    private final PingPongMessageParser protocol = new PingPongMessageParser();

    @Test(expected=PartialMessageException.class)
    public void empty() throws Exception {
        this.parse();
    }

    @Test(expected=PartialMessageException.class)
    public void partialMessage() throws Exception {
        this.receiveBuffer.put("PO".getBytes());
        this.receiveBuffer.flip();
        this.parse();
    }

    @Test
    public void completeMessage() throws Exception {
        this.receiveBuffer.put("PONG\n".getBytes());
        this.receiveBuffer.flip();
        String message = this.parse();
        Assert.assertEquals((Object)"PONG\n", (Object)message);
    }

    private String parse() throws PartialMessageException {
        return this.protocol.parse(this.receiveBuffer);
    }
}

