/*
 * Decompiled with CFR 0.152.
 */
package silvertip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import jline.ConsoleReader;
import silvertip.Console;
import silvertip.EventSource;

public class CommandLine
implements EventSource {
    private static final String PROMPT = "> ";
    private static final Charset charset = Charset.forName("UTF-8");
    private static final CharsetDecoder decoder = charset.newDecoder();
    private SelectionKey selectionKey;
    private final Callback callback;
    private SystemInPipe stdinPipe;

    public static CommandLine open(Callback callback) throws IOException {
        return CommandLine.open(new Console(){
            private final ConsoleReader reader = new ConsoleReader();

            @Override
            public void println(String string) throws IOException {
                this.reader.putString(string);
            }

            @Override
            public String readLine(String prompt) throws IOException {
                return this.reader.readLine(prompt);
            }
        }, callback);
    }

    public static CommandLine open(Console console, Callback callback) throws IOException {
        SystemInPipe stdinPipe = new SystemInPipe(console);
        CommandLine result = new CommandLine(callback, stdinPipe);
        stdinPipe.start(result);
        return result;
    }

    public CommandLine(Callback callback, SystemInPipe stdinPipe) {
        this.callback = callback;
        this.stdinPipe = stdinPipe;
    }

    @Override
    public SelectionKey register(Selector selector, int ops) throws IOException {
        this.selectionKey = this.getChannel().register(selector, ops);
        return this.selectionKey;
    }

    @Override
    public void unregister() {
    }

    private SelectableChannel getChannel() {
        try {
            return this.stdinPipe.getStdinChannel();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void read(SelectionKey key) throws IOException {
        ByteBuffer rxBuffer;
        ReadableByteChannel sc = (ReadableByteChannel)((Object)key.channel());
        if (sc.read(rxBuffer = ByteBuffer.allocate(255)) < 0) {
            this.close();
        }
        rxBuffer.flip();
        this.callback.commandLine(decoder.decode(rxBuffer).toString());
    }

    @Override
    public void write(SelectionKey key) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EventSource accept(SelectionKey key) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void timeout() {
    }

    public void close() {
        this.selectionKey.attach(null);
        this.selectionKey.cancel();
        SelectableChannel sc = this.selectionKey.channel();
        try {
            sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.selectionKey.selector().wakeup();
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    private static class SystemInPipe {
        private CopyThread copyThread;
        private Console console;
        private Pipe pipe;

        public SystemInPipe(Console console) throws IOException {
            this.console = console;
            this.pipe = Pipe.open();
        }

        public void start(CommandLine commandLine) throws IOException {
            this.copyThread = new CopyThread(commandLine, this.console, this.pipe.sink());
            this.copyThread.start();
        }

        public SelectableChannel getStdinChannel() throws IOException {
            Pipe.SourceChannel result = this.pipe.source();
            ((SelectableChannel)result).configureBlocking(false);
            return result;
        }

        private class CopyThread
        extends Thread {
            private final CommandLine commandLine;
            private final WritableByteChannel out;
            private final Console console;

            CopyThread(CommandLine commandLine, Console console, WritableByteChannel out) throws IOException {
                this.commandLine = commandLine;
                this.console = console;
                this.out = out;
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.console.readLine(CommandLine.PROMPT)) != null) {
                        ByteBuffer buffer = ByteBuffer.wrap(line.getBytes());
                        this.out.write(buffer);
                    }
                    this.out.close();
                    this.commandLine.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static interface Callback {
        public void commandLine(String var1);
    }
}

