/*
 * Decompiled with CFR 0.152.
 */
package silvertip;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import silvertip.EventSource;
import silvertip.GarbledMessageException;
import silvertip.Message;
import silvertip.MessageParser;
import silvertip.PartialMessageException;

public class Connection<T>
implements EventSource {
    private List<ByteBuffer> txBuffers = Collections.synchronizedList(new LinkedList());
    private ByteBuffer rxBuffer = ByteBuffer.allocate(4096);
    private SelectionKey selectionKey;
    private SocketChannel channel;
    private MessageParser<T> parser;
    private Callback<T> callback;

    public static <T> Connection<T> connect(InetSocketAddress address, MessageParser<T> parser, Callback<T> callback) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.connect(address);
        channel.configureBlocking(false);
        return new Connection<T>(channel, parser, callback);
    }

    public Connection(SocketChannel channel, MessageParser<T> parser, Callback<T> callback) {
        this.channel = channel;
        this.callback = callback;
        this.parser = parser;
    }

    @Override
    public SelectionKey register(Selector selector, int ops) throws IOException {
        this.selectionKey = this.channel.register(selector, ops);
        return this.selectionKey;
    }

    @Override
    public void unregister() {
        this.callback.closed(this);
    }

    @Override
    public void read(SelectionKey key) throws IOException {
        SocketChannel sc = (SocketChannel)key.channel();
        if (sc.isOpen()) {
            int len;
            try {
                len = sc.read(this.rxBuffer);
            }
            catch (IOException e) {
                len = -1;
            }
            if (len > 0) {
                Iterator<T> messages = this.parse();
                if (messages.hasNext()) {
                    this.callback.messages(this, messages);
                }
            } else if (len < 0) {
                this.close();
            }
        }
    }

    private Iterator<T> parse() throws IOException {
        this.rxBuffer.flip();
        ArrayList<T> result = new ArrayList<T>();
        while (this.rxBuffer.hasRemaining()) {
            this.rxBuffer.mark();
            try {
                result.add(this.parser.parse(this.rxBuffer));
            }
            catch (PartialMessageException e) {
                this.rxBuffer.reset();
                break;
            }
            catch (GarbledMessageException e) {
                this.callback.garbledMessage(e.getMessage(), e.getMessageData());
            }
        }
        this.rxBuffer.compact();
        return result.iterator();
    }

    public void send(byte[] byteArray) {
        this.send(ByteBuffer.wrap(byteArray));
    }

    public void send(Message message) {
        this.send(message.toByteBuffer());
    }

    public void send(ByteBuffer buffer) {
        this.txBuffers.add(buffer);
        if (this.selectionKey == null) {
            throw new IllegalStateException("Connection is not registered");
        }
        this.selectionKey.interestOps(5);
        this.selectionKey.selector().wakeup();
    }

    @Override
    public void write(SelectionKey key) throws IOException {
        try {
            this.flush();
        }
        catch (IOException e) {
            this.close();
        }
        if (this.txBuffers.isEmpty()) {
            key.interestOps(1);
        }
    }

    public void close() {
        SocketChannel sc;
        Socket socket;
        try {
            while (!this.txBuffers.isEmpty()) {
                this.flush();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if ((socket = (sc = (SocketChannel)this.selectionKey.channel()).socket()) != null) {
            try {
                socket.shutdownInput();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                socket.shutdownOutput();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.selectionKey.attach(null);
        this.selectionKey.cancel();
        this.selectionKey.selector().wakeup();
    }

    private void flush() throws IOException {
        ByteBuffer txBuffer;
        while (!this.txBuffers.isEmpty() && this.write(txBuffer = this.txBuffers.get(0))) {
            this.txBuffers.remove(0);
        }
    }

    private boolean write(ByteBuffer txBuffer) throws IOException {
        while (txBuffer.hasRemaining()) {
            if (this.channel.write(txBuffer) != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void timeout() {
        this.callback.idle(this);
    }

    @Override
    public EventSource accept(SelectionKey key) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() {
        SocketChannel sc = (SocketChannel)this.selectionKey.channel();
        return !sc.isOpen();
    }

    public static interface Callback<T> {
        public void messages(Connection<T> var1, Iterator<T> var2);

        public void idle(Connection<T> var1);

        public void closed(Connection<T> var1);

        public void garbledMessage(String var1, byte[] var2);
    }
}

